<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order_detail extends Model 
{

    protected $table = 'Order_detail';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'quantity');
    protected $visible = array('sub_total');

    public function detailsProduct()
    {
        return $this->hasMany('App\Models\Product', 'product_id');
    }

}